﻿//using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Text;

using System.Windows.Forms;
using System.Collections.Generic;

namespace GFXEditor
{
    /// <summary>
    /// A panel displaying info about an entity
    /// </summary>
    class panelEntity
    {
        /// <summary>
        /// Panel containing the layout and the controls
        /// </summary>
        public Panel                _group;

        /// <summary>
        /// Layout containing the controls
        /// </summary>
        public TableLayoutPanel     _layout;

        /// <summary>
        /// List of labels
        /// </summary>
        public List<Label>          _listLabel;

        /// <summary>
        /// List of controls
        /// </summary>
        public List<Control>        _listControl;

        /// <summary>
        /// Class name of the entity
        /// </summary>
        public string               _entityClassName;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="entityClassName"></param>
        public panelEntity(string entityClassName)
        {
            _group = new Panel();
            _group.AutoScroll = true;
            _entityClassName = entityClassName;

            _layout = new TableLayoutPanel();
            _layout.ColumnCount = 2;
            _group.Controls.Add(_layout);

            _listControl = new List<Control>();
            _listLabel = new List<Label>();
        }

        /// <summary>
        /// Add a control to the panel
        /// </summary>
        /// <param name="text">Text to dislay in front of the control</param>
        /// <param name="ctrl">Control</param>
        public void addControl(string text, Control ctrl)
        {
            Label newLabel = new Label();
            newLabel.Text = text;
            newLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;

            _layout.Controls.Add(newLabel, 0, _listControl.Count);
            _layout.Controls.Add(ctrl, 1, _listControl.Count);
            
            _listLabel.Add(newLabel);
            _listControl.Add(ctrl);
        }

        public Control getControl(string tag)
        {
            for (int i = 0; i < _listControl.Count; i++)
            {
                if (_listControl[i].Tag.ToString() == tag)
                    return _listControl[i];
            }
            return null;
        }
    }
}
