﻿//using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Text;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using GE.Visualisation;

namespace GFXEditor.Level
{
    class Level
    {
        Visu _visu;
        public string _name;
        public List<Entity> _listSprite;
        public Entity _playerEntity;
        public List<Rectangle> _listPlatform;
        public List<Rectangle> _listLadder;
        public List<Rectangle> _listSpike;

        public List<object> _listEntity;

        public Level(Visu v)
        {
            _visu = v;
            _name = "";
            _listSprite = new List<Entity>();
            _listPlatform = new List<Rectangle>();
            _listLadder = new List<Rectangle>();
            _listSpike = new List<Rectangle>();
            _playerEntity = new Entity();
            _playerEntity._type = eEntityType.ePlayer;
            _listEntity = new List<object>();
        }

        public int getSelectedSprite(Vector2 worldPosition)
        {
            for (int i = 0; i < _listSprite.Count; i++)
            {
                Entity e = _listSprite[i];
                if (worldPosition.X >= e._position.X && worldPosition.X <= e._position.X + _visu.getSpriteWidth(e._idTexture, e._idSprite) &&
                    worldPosition.Y >= e._position.Y && worldPosition.Y <= e._position.Y + _visu.getSpriteHeight(e._idTexture, e._idSprite))
                    return i;
            }
            return -1;
        }

        public int getSelectedPlatform(Vector2 worldPosition)
        {
            for (int i = 0; i < _listPlatform.Count; i++)
            {
                Rectangle r = _listPlatform[i];
                if (worldPosition.X >= r.X && worldPosition.X <= r.X + r.Width &&
                    worldPosition.Y >= r.Y && worldPosition.Y <= r.Y + r.Height)
                    return i;
            }
            return -1;
        }

        public int getSelectedLadder(Vector2 worldPosition)
        {
            for (int i = 0; i < _listLadder.Count; i++)
            {
                Rectangle r = _listLadder[i];
                if (worldPosition.X >= r.X && worldPosition.X <= r.X + r.Width &&
                    worldPosition.Y >= r.Y && worldPosition.Y <= r.Y + r.Height)
                    return i;
            }
            return -1;
        }

        public int getSelectedSpike(Vector2 worldPosition)
        {
            for (int i = 0; i < _listSpike.Count; i++)
            {
                Rectangle r = _listSpike[i];
                if (worldPosition.X >= r.X && worldPosition.X <= r.X + r.Width &&
                    worldPosition.Y >= r.Y && worldPosition.Y <= r.Y + r.Height)
                    return i;
            }
            return -1;
        }

        /// <summary>
        /// Check if the point worldPosition is in an entity and return the entity id
        /// </summary>
        /// <param name="worldPosition"></param>
        /// <returns>The id of the selected entity. -1 if no entity selected.</returns>
        public int getSelectedEntity(Vector2 worldPosition)
        {
            for (int i = 0; i < _listEntity.Count; i++)
            {
                Vector2 pos = (Vector2)_listEntity[i].GetType().GetField("Position").GetValue(_listEntity[i]);
                int idTexture = (int)_listEntity[i].GetType().GetField("EDITOR_TILESET").GetValue(null);
                int idSprite = (int)_listEntity[i].GetType().GetField("EDITOR_SPRITE").GetValue(null);

                
                if (worldPosition.X >= pos.X && worldPosition.X <= pos.X + _visu.getSpriteWidth(idTexture, idSprite) &&
                    worldPosition.Y >= pos.Y && worldPosition.Y <= pos.Y + _visu.getSpriteHeight(idTexture, idSprite))
                    return i;
            }
            return -1;
        }

        /// <summary>
        /// Check if the point is inside an entity
        /// </summary>
        /// <param name="worldPosition"></param>
        /// <param name="idEntity"></param>
        /// <returns></returns>
        public bool isEntitySelected(Vector2 worldPosition, int idEntity)
        {
            object e = _listEntity[idEntity];
            Vector2 pos = (Vector2)e.GetType().GetField("Position").GetValue(e);
            int idTexture = (int)e.GetType().GetField("EDITOR_TILESET").GetValue(null);
            int idSprite = (int)e.GetType().GetField("EDITOR_SPRITE").GetValue(null);

            if (worldPosition.X >= pos.X && worldPosition.X <= pos.X + _visu.getSpriteWidth(idTexture, idSprite) &&
                worldPosition.Y >= pos.Y && worldPosition.Y <= pos.Y + _visu.getSpriteHeight(idTexture, idSprite))
                return true;

            return false;
        }
    }
}
