﻿using System;

namespace GE.TimeClock
{
    class Clock
    {
        /// <summary>
        /// singleton
        /// </summary>
        static Clock m_instance = new Clock();

        /// <summary>
        /// Represent the time when the Clock was initialised.
        /// </summary>
        DateTime m_startTime;

        /// <summary>
        /// the time when stopClock was called
        /// </summary>
        DateTime m_dateOffsetTime;

        int m_offsetTime;

        /// <summary>
        /// 
        /// </summary>
        public static Clock instance
        {
            get
            {
                return m_instance;
            }
        }

        public Clock()
        {
            m_startTime = DateTime.Now;
            m_dateOffsetTime = DateTime.Now;
            m_offsetTime = 0;
        }

        public bool init() { return true; }

        public int millisecs
        {
            get
            {
                return (int)DateTime.Now.Subtract(m_startTime).TotalMilliseconds - m_offsetTime;
            }
        }

        public void stopClock()
        {
            m_dateOffsetTime = DateTime.Now;
        }

        /// <summary>
        /// To call only if stopClock was called before
        /// </summary>
        public void startClock()
        {
            m_offsetTime += (int)DateTime.Now.Subtract(m_dateOffsetTime).TotalMilliseconds;
        }




            
    }
}
