﻿using System.Collections.Generic;
using System.Xml;

using GE.Tools;

namespace GE.Tools
{
    /// <summary>
    /// Manages languages.
    /// </summary>
    class Localization
    {
        /// <summary>
        /// Node name in the XML file.
        /// </summary>
        private const string NODE_NAME = "string";

        /// <summary>
        /// Key name in the XML file.
        /// </summary>
        private const string KEY_NAME = "key";

        /// <summary>
        /// Value name in the XML file.
        /// </summary>
        private const string VALUE_NAME = "value";

        /// <summary>
        /// Unique instance of the Localization class.
        /// </summary>
        private static Localization m_instance = new Localization();

        /// <summary>
        /// Likns keys to translated strings.
        /// </summary>
        private Dictionary<string, string> m_table;

        /// <summary>
        /// Unique instance of the Localization class.
        /// </summary>
        public static Localization Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private Contructor.
        /// </summary>
        private Localization()
        {
            m_table = new Dictionary<string, string>();
        }

        /// <summary>
        /// Initializes the Localizion component.
        /// </summary>
        /// <param name="filename">language file</param>
        /// <returns>false if a problem occured</returns>
        public bool init(string filename)
        {
            m_table.Clear(); // in case of re-init

            XmlDocument doc = new XmlDocument();

            try
            {
                doc.Load(filename);
            }
            catch
            {
                return false;
            }

            XmlElement localization = doc.DocumentElement;
            XmlNodeList strings = localization.GetElementsByTagName(NODE_NAME);

            m_table.Clear(); // in case of language change
            foreach (XmlNode node in strings)
                m_table[node.Attributes[KEY_NAME].Value] = node.Attributes[VALUE_NAME].Value;

            return true;
        }

        /// <summary>
        /// Get a translated string.
        /// </summary>
        /// <param name="id">key</param>
        /// <returns>translated string, "**ERROR**" if an error occured</returns>
        public string getString(string id)
        {
            if(m_table.ContainsKey(id))
                return m_table[id];
            return "**ERROR**";
        }
    }
}
