using System;
using System.Collections.Generic;
using System.Reflection;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.GamerServices;

//using GE.Gui.Forms;

namespace GE.Tools
{
    /// <summary>
    /// Error Manager.
    /// </summary>
    class Logger
    {
        /// <summary>
        /// Unique instance of the Logger class.
        /// </summary>
        private static Logger m_instance = new Logger();

        /// <summary>
        /// Game instance.
        /// </summary>
        private object m_game;

        /// <summary>
        /// MethodInfo of the Exit method of the game.
        /// </summary>
        private MethodInfo m_exit;

        /// <summary>
        /// Property of m_instance.
        /// </summary>
        public static Logger Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private Constructor.
        /// </summary>
        private Logger()
        {
        }

        /// <summary>
        /// Initializes the Logger component.
        /// </summary>
        /// <param name="game">game instance</param>
        /// <param name="exit">MethodInfo of the Exit method of the game</param>
        public void init(object game, MethodInfo exit)
        {
            m_game = game;
            m_exit = exit;
        }

        /// <summary>
        /// Sends an error.
        /// </summary>
        /// <param name="emitter">objet mettant l'erreur</param>
        /// <param name="message">message d'erreur</param>
        public void error(object emitter, string message)
        {
            error(emitter, null, message);
        }

        /// <summary>
        /// Sends an error.
        /// </summary>
        /// <param name="emitter">objet mettant l'erreur</param>
        /// <param name="exception">exception ayant provoque l'erreur</param>
        /// <param name="message">message d'erreur</param>
        public void error(object emitter, Exception exception, string message)
        {
            //if (Guide.IsVisible)
            //    return;
            //List<string> buttons = new List<string>();
            //buttons.Add("Ok");
            
            //Guide.BeginShowMessageBox(PlayerIndex.One, "Error",
            //    message + "\nFrom : " + emitter.ToString(),
            //    buttons, 0, MessageBoxIcon.Error, new AsyncCallback(errorCallback), null);
            System.Windows.Forms.MessageBox.Show(message + "\nFrom : " + emitter.ToString());
        }

        public void errorCallback(IAsyncResult result)
        {
            //Guide.EndShowMessageBox(result);
            exit();
        }

        /// <summary>
        /// Exits the game.
        /// </summary>
        private void exit()
        {
            object[] args = { };
            m_exit.Invoke(m_game, args);
        }
    }
}
