﻿using System;
using System.Collections.Generic;
using System.Xml;
using System.IO;

namespace GE.Tools
{
    class Profiler
    {
        class Measure
        {
            public TimeSpan Total;
            public DateTime Start;
            public int Ticks;

            public Measure()
            {
                Total = TimeSpan.Zero;
                Ticks = 0;
            }
        }

        private static Profiler m_instance = new Profiler();
        private Dictionary<string, Measure> m_measures;

        public static Profiler Instance
        {
            get { return m_instance; }
        }

        private Profiler()
        {
            m_measures = new Dictionary<string, Measure>();
        }

        public void start(string name)
        {
            if (!m_measures.ContainsKey(name))
                m_measures.Add(name, new Measure());
            m_measures[name].Start = DateTime.Now;
        }

        public void stop(string name)
        {
            if (m_measures.ContainsKey(name))
            {
                Measure m = m_measures[name];
                m.Total += DateTime.Now.Subtract(m.Start);
                m.Ticks++;
            }
        }

        public void output(string filename)
        {
#if XBOX360
            return;
#endif
            XmlTextWriter writer = new XmlTextWriter(filename, System.Text.Encoding.UTF8);
            writer.Formatting = Formatting.Indented;
            writer.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
            writer.WriteStartElement("profiling");
            writer.Close();

            XmlDocument doc = new XmlDocument();
            doc.Load(filename);
            XmlElement root = doc.DocumentElement;

            foreach (string s in m_measures.Keys)
            {
                Measure measure = m_measures[s];
                XmlElement element = doc.CreateElement("measure");
                element.SetAttribute("name", s);
                element.SetAttribute("ticks", measure.Ticks.ToString());
                element.SetAttribute("totalDuration", measure.Total.TotalMilliseconds.ToString());
                element.SetAttribute("tickDuration",
                    ((double)measure.Total.TotalMilliseconds / measure.Ticks).ToString());
                root.AppendChild(element);
            }

            doc.Save(filename);
        }
    }
}
