﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace GE.Tools
{
    /// <summary>
    /// Contains string tools.
    /// </summary>
    class StringTools
    {
        /// <summary>
        /// Add CRs to display a string on several lines.
        /// </summary>
        /// <param name="text">text to trear</param>
        /// <param name="maxLenght">maximum length of a line</param>
        /// <param name="nbLines">number of lines</param>
        /// <returns>treated text</returns>
        public static string breakString(string text, int maxLenght, ref int nbLines)
        {
            string formattedText = "";
            int lastBreak = 0;
            int lastCut = 0;
            int lines = 0;
            for (int i = 0; i < text.Length; i++)
            {
                if (text[i] == ' ' || text[i] == '/' || text[i] == '\\')
                    lastBreak = i;
                if (i - lastCut == maxLenght)
                {
                    formattedText += text.Substring(lastCut, lastBreak - lastCut) + "\n";
                    lastCut = lastBreak;
                    lines++;
                }
            }
            if (lastCut < text.Length)
                formattedText += text.Substring(lastCut);
            formattedText = formattedText.Replace("\n ", "\n");

            nbLines = lines;
            return formattedText;
        }
    }
}
