using System.Xml;

using Microsoft.Xna.Framework;

namespace GE.Tools
{
    static class XmlHelper
    {
        public static float getFloatFromNode(XmlNode node)
        {
            return (float)double.Parse(node.InnerText);
        }

        public static int getIntFromNode(XmlNode node)
        {
            return int.Parse(node.InnerText);
        }

        public static string getStringFromNode(XmlNode node)
        {
            return node.InnerText;
        }

        public static Vector2 getVector2FromNode(XmlNode node)
        {
            string[] separated = node.InnerText.Split(' ');

            return new Vector2(float.Parse(separated[0]), float.Parse(separated[1]));
        }

        public static Vector2 getVector2FromAttribute(XmlAttribute a)
        {
            string[] separated = a.InnerText.Split(' ');
            return new Vector2(float.Parse(separated[0]), float.Parse(separated[1]));
        }

        public static Vector3 getVector3FromNode(XmlNode node)
        {
            string[] separated = node.InnerText.Split(' ');

            return new Vector3(float.Parse(separated[0]), float.Parse(separated[1]), float.Parse(separated[2]));
        }

        public static float getFloatFromAttribute(XmlAttribute a)
        {
            return float.Parse(a.InnerText);
        }

        public static int getIntFromAttribute(XmlAttribute a)
        {
            return int.Parse(a.InnerText);
        }

        public static string getStringFromAttribute(XmlAttribute a)
        {
            return a.InnerText;
        }

        public static bool getBoolFromAttribute(XmlAttribute a)
        {
            if (a.InnerText == "true")
                return true;
            else
                return false;
        }

        public static string[] getWordsFromNode(XmlNode node)
        {
            return node.InnerText.Split(' ');
        }

    }
}