﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GFXEditor
{
    public partial class wndMain : Form
    {
        public wndMain()
        {
            InitializeComponent();
        }

        private void newToolStripMenuItem_Click(object sender, EventArgs e)
        {
            wndSpritesheet newSpriteSheet = new wndSpritesheet();
            newSpriteSheet.MdiParent = this;
            newSpriteSheet.Show();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //create an openfiledialog
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Title = "Open spritesheet";
            ofd.Filter = "Xml file (.xml)|*.xml";

            //open the file dialog window
            DialogResult res = ofd.ShowDialog();
            if (res != DialogResult.OK) return;

            //create the spritesheet window
            wndSpritesheet newSpritesheet = new wndSpritesheet(ofd.FileName);
            newSpritesheet.MdiParent = this;
            newSpritesheet.Show();
        }


        private void openToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            //create an open file dialog
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Title = "Open Animations";
            ofd.Filter = "Xml files (*.xml)|*.xml";

            //open the file dialog
            DialogResult res = ofd.ShowDialog();
            if (res != DialogResult.OK) return;

            //show the animations window
            wndAnimation newAnimation = new wndAnimation(ofd.FileName);
            newAnimation.MdiParent = this;
            newAnimation.Show();
        }

        private void newToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            wndLevel newLevel = new wndLevel();
            newLevel.MdiParent = this;
            newLevel.Show();
        }

        private void openToolStripMenuItem2_Click(object sender, EventArgs e)
        {
            //ope a dialog
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Xml files (*.xml)|*.xml";
            ofd.Title = "Open level";

            DialogResult res = ofd.ShowDialog();
            if (res != System.Windows.Forms.DialogResult.OK) return;

            wndLevel newLevel = new wndLevel(ofd.FileName);
            newLevel.MdiParent = this;
            newLevel.Show();
        }
    }
}
